<?php
namespace OAuth\Unit\UserData\Extractor;

use OAuth\UserData\Extractor\Twitter;

/**
 * Generated by PHPUnit_SkeletonGenerator 1.2.1 on 2014-02-08 at 00:52:53.
 */
class TwitterTest extends \PHPUnit_Framework_TestCase
{
    const PROFILE_RESPONSE =
'{
  "name": "Matt Harris",
  "profile_sidebar_border_color": "C0DEED",
  "profile_background_tile": false,
  "profile_sidebar_fill_color": "DDEEF6",
  "location": "San Francisco",
  "profile_image_url": "http://a1.twimg.com/profile_images/554181350/matt_normal.jpg",
  "created_at": "Sat Feb 17 20:49:54 +0000 2007",
  "profile_link_color": "0084B4",
  "favourites_count": 95,
  "url": "http://themattharris.com",
  "entities": {
    "url": {
      "urls": [{
        "url": "http:\/\/t.co\/78pYTvWfJd",
        "expanded_url": "http:\/\/dev.twitter.com",
        "display_url": "dev.twitter.com",
        "indices": [0, 22]
      }]
    },
    "description": {
      "urls": []
    }
  },
  "contributors_enabled": false,
  "utc_offset": -28800,
  "id": 777925,
  "profile_use_background_image": true,
  "profile_text_color": "333333",
  "protected": false,
  "followers_count": 1025,
  "lang": "en",
  "verified": false,
  "profile_background_color": "C0DEED",
  "geo_enabled": true,
  "notifications": false,
  "description": "Developer Advocate at Twitter.",
  "time_zone": "Tijuana",
  "friends_count": 294,
  "statuses_count": 2924,
  "profile_background_image_url": "http://s.twimg.com/a/1276711174/images/themes/theme1/bg.png",
  "status": {
    "coordinates": {
      "coordinates": [
        -122.40075845,
        37.78264991
      ],
      "type": "Point"
    },
    "favorited": false,
    "created_at": "Tue Jun 22 18:17:48 +0000 2010",
    "truncated": false,
    "text": "Going through and updating @twitterapi documentation",
    "contributors": null,
    "id": 16789004997,
    "geo": {
      "coordinates": [
        37.78264991,
        -122.40075845
      ],
      "type": "Point"
    },
    "in_reply_to_user_id": null,
    "place": null,
    "source": "<a href=\"http://itunes.apple.com/app/twitter/id333903271?mt=8\" rel=\"nofollow\">Twitter for iPhone</a>",
    "in_reply_to_screen_name": null,
    "in_reply_to_status_id": null
  },
  "screen_name": "themattharris",
  "following": false
}';

    /**
     * @var Twitter
     */
    protected $extractor;

    /**
     * Sets up the fixture, for example, opens a network connection.
     * This method is called before a test is executed.
     */
    protected function setUp()
    {
        $this->extractor = new Twitter();
        $service = $this->getMockBuilder('\\OAuth\\OAuth1\\Service\\Twitter')
            ->disableOriginalConstructor()
            ->getMock();
        $service->expects($this->any())
            ->method('request')
            ->with(Twitter::REQUEST_PROFILE)
            ->will($this->returnValue(TwitterTest::PROFILE_RESPONSE));
        /**
         * @var \OAuth\Common\Service\ServiceInterface $service
         */
        $this->extractor->setService($service);
    }

    /**
     * Tears down the fixture, for example, closes a network connection.
     * This method is called after a test is executed.
     */
    protected function tearDown()
    {
    }

    public function testDoesNotSupportEmail()
    {
        $this->assertFalse($this->extractor->supportsEmail());
        $this->assertNull($this->extractor->getEmail());
    }

    public function testDoesNotSupportVerifiedEmail()
    {
        $this->assertFalse($this->extractor->supportsVerifiedEmail());
        $this->assertNull($this->extractor->isEmailVerified());
    }

    public function testGetUniqueId()
    {
        $this->assertEquals(777925, $this->extractor->getUniqueId());
    }

    public function testGetUsername()
    {
        $this->assertEquals('themattharris', $this->extractor->getUsername());
    }

    public function testGetFullName()
    {
        $this->assertEquals('Matt Harris', $this->extractor->getFullName());
    }

    public function testGetFistName()
    {
        $this->assertEquals('Matt', $this->extractor->getFirstName());
    }

    public function testGetLastName()
    {
        $this->assertEquals('Harris', $this->extractor->getLastName());
    }

    public function testGetDescription()
    {
        $this->assertEquals('Developer Advocate at Twitter.', $this->extractor->getDescription());
    }

    public function testGetLocation()
    {
        $this->assertEquals('San Francisco', $this->extractor->getLocation());
    }

    public function testGetProfileUrl()
    {
        $this->assertEquals('https://twitter.com/themattharris', $this->extractor->getProfileUrl());
    }

    public function testGetImageUrl()
    {
        $this->assertEquals(
            'http://a1.twimg.com/profile_images/554181350/matt_normal.jpg',
            $this->extractor->getImageUrl()
        );
    }

    public function testGetWebsites()
    {
        $websites = array(
            'http://themattharris.com',
            'http://dev.twitter.com'
        );
        $this->assertEquals($websites, $this->extractor->getWebsites());
    }

    public function testGetExtra()
    {
        $extra = $this->extractor->getExtras();

        $this->assertArrayHasKey('profile_sidebar_border_color', $extra);
        $this->assertArrayHasKey('profile_background_tile', $extra);
        $this->assertArrayHasKey('profile_sidebar_fill_color', $extra);

        $this->assertArrayNotHasKey('name', $extra);
        $this->assertArrayNotHasKey('id', $extra);
        $this->assertArrayNotHasKey('description', $extra);
    }
}
